# URL鉴权方式A

## 原理
URL鉴权是通过一定算法重新生成网站上的资源链接URL（比如下载链接、音频链接等），来实现防盗链的目的；因为这些链接都带有过期时间，所以即使被别的网站引用，也必须频繁更换链接。

比如你的原网站链接是：
~~~
https://example.com/images/test.jpg
~~~

经过算法处理后是：
~~~
https://example.com/images/test.jpg?sign=1661824870-c6d1a57067b21f7b-0baac47b6c2ad519bb1bfe7babff37a3
~~~

然后把网站上原有链接改为经过算法处理后的链接，即实现了URL鉴权功能。

## 算法详解

### 示例URL
~~~
https://example.com/images/test.jpg?sign=1661824870-c6d1a57067b21f7b-0baac47b6c2ad519bb1bfe7babff37a3
~~~

### URL生成规则
~~~
(http|https)://域名/文件路径?sign=时间戳-随机字符串-Hash值
~~~
其中：
* `sign` - 为默认的签名参数，可以自行修改
* `域名` - 保留原来的域名，比如 `example.com`
* `/文件路径` - 文件路径包含了最前面的斜杠（`/`）符号，比如 `/images/test.jpg`
* `时间戳` - Unix时间戳，单位是秒，比如 `1661824870`
* `随机字符串` - 你自定义的随机字符串，只能包含字母、数字，比如 `c6d1a57067b21f7b`，也可以是一个固定的值，比如 `hello`，但固定值会降低安全性
* `Hash值` - 目前只支持MD5 Hash算法，具体为：
    ~~~~javascript
    md5("/文件路径@时间戳@随机字符串@密钥")
    ~~~~
    其中密钥是你在创建鉴权方式时生成或填写的鉴权密钥；各个字段使用 `@` 符号连接，且文件路径前的斜杠（`/`）别忘记填写，也不要重复填写；以密钥为 `123456` 为例：
    ~~~~javascript
    md5("/images/test.jpg@1661824870@c6d1a57067b21f7b@123456") // => 0baac47b6c2ad519bb1bfe7babff37a3
    ~~~~
    结果需要是一个32位的仅包含小写字母和数字的字符串；如果你使用的算法结果是大写的，请转换为小写的

### 回源规则
查找缓存和回源规则时，会自动移除 `sign` 参数

### 常见问题
#### URL中可以添加其他参数吗？
URL中可以添加其他参数，比如：
~~~
https://example.com/images/test.jpg?sign=1661824870-c6d1a57067b21f7b-0baac47b6c2ad519bb1bfe7babff37a3&v=1&from=google
~~~
其中 `v=1&from=google` 参数是自定义参数，可以正确回源到源站。

## 注意事项
由于URL鉴权是动态生成URL的，所以链接所在的页面的缓存时间设置不能超过鉴权设置的有效时间。