# 正则表达式

以下是一些常用的正则表达式用法：

## 开始和结束
同其他正则表达式一样，可以使用`^`和`$`表示开始和结束：
* `^abc` - 必须以`abc`开始
* `efg$` - 必须以`efg`结束
* `^abc.+efg$` - 匹配对象必须是以`abc`开始，`efg`结束

## 字符集
* `.` - 点（`.`）符号表示匹配任何字符，包括换行符
* `[abc]` - 字符集，表示匹配`abc`字符中的任何一个
* `[^abc]` - 反向字符集，表示不匹配`abc`字符中的任何一个
* `\d` - 数字字符集，相当于`[0-9]`
* `\D` - 非数字字符集，相当于`[^0-9]`
* `\w` - 单词字符集，相当于`[0-9A-Za-z_]`
* `\W` - 非单词字符集，相当于`[^0-9A-Za-z_]`
* `\s` - 空白字符集，相当于`[\t\n\f\r ]`
* `\S` - 非空白字符集，相当于`[^\t\n\f\r ]`
* `\b` - 单词边界
* `\B` - 非单词边界
* `[[:alpha:]]` - ASCII字符集
* `[[:^alpha:]]` - 非ASCII字符集
* `\pN` - Unicode字符集，只有一个字符
* `\p{Greek}` - Unicode字符集
* `\p{Han}` - 中文字符集
* `\PN` - 非Unicode字符集，只有一个字符
* `\P{Greek}` - 非Unicode字符集

## 组合
* `xy` - `x`和`y`相邻，`y`紧跟`x`之后
* `x|y` - `x`或`y`，遇到`x`即宣告匹配成功

## 重复
* `x*` - 0或多个`x`，尽可能匹配最多的`x`
* `x+` - 1或多个`x`，尽可能匹配最多的`x`
* `x?` - 0或1个`x`，尽可能匹配最多的`x`
* `x{n,m}` - n到m个`x`，尽可能匹配最多的`x`
* `x{n,}` - n个以上的`x`，包括n个`x`，尽可能匹配最多的`x`
* `x{n}` - n个`x`
* `x*?` - 0或多个`x`，尽可能匹配最少的`x`
* `x+?` - 1或多个`x`，尽可能匹配最少的`x`
* `x??` - 0或1个`x`，尽可能匹配最少的`x`
* `x{n,m}?` - n到m个`x`，尽可能匹配最少的`x`
* `x{n,}?` - n个以上的`x`，包括n个`x`，尽可能匹配最少的`x`
* `x{n}?` - n个`x`

## 分组
使用圆括号进行分组：
* `(re)` - 编号从1开始，0表示全部匹配的内容
	* 比如`(hello)(world)`匹配结果就有两个分组，编号分别为1和2
* `(?P<name>re)` - 命名分组
	* 比如使用`(?P<myName>\w+)`来匹配`ZhangSan`，那么`myName`对应的值就被定义为`ZhangSan`
* `(?:re)` - 跳过分组
	* 比如`(?:hello)(world)`匹配结果就只有一个分组`(world)`，编号为1；因为`hello`这个分组被跳过

## 标记
在别的正则表达式中称之为修饰符（`modifier`）：
* `i` - 表示大小写 **不** 敏感
* `m` - 多行匹配，如果有`$`结束字符的时候需要此标记
* `s` - 让点符号（`.`）也匹配`\n`
* `U` - 非贪婪模式，匹配结果尽可能少地匹配

使用`(?FLAG)`或`(?:FLAG)`语法来使用这些标记，并且这里的括号并不会产生新的分组：
~~~
(?i)hello
(?i:hello)
~~~
以上两个表达式都表示大小写不敏感，所以`HELLO`、`Hello`、`hello`都认为匹配成功。

## 转义字符
使用反斜杠表示转义字符，用来表示某个字符是原始的字符，而不是正则表达式，比如匹配文件扩展名：
~~~
\.(php|asp|jsp|py)
~~~
中的点（.）因为在正则表达式中有别的意义，所以需要用反斜杠转义。