# 重写规则
可以在网站“设置” -- “重写规则”中添加重写规则，将某个或者某一类URL映射到另外一个或一组URL上。

## 示例
### 示例1：将 `/a/abc.html` 重写到 `/b/abc.html`
* 匹配规则：`^/a/(.+)$`
* 目标URL：`/b/${1}` （其中`${1}`是匹配规则中第一个括号匹配的内容）

### 示例2：将任何URL都增加一个 `/prefix` 目录
* 匹配规则：`^(.+)$`
* 目标URL：`/prefix${1}` （这里没有加入`/`，因为匹配的内容中已经包含）

### 示例3：将 `/123_456.html` 类似的URL重写为目录
* 匹配规则：`^/(\d+)_(\d+)\.html$` （其中`\d`表示数字，并注意`.`符号是特殊符号，需要转义变成`\.`）
* 目标URL：`/${1}/${2}/index.html` （变成`/123/456/index.html`）